# Dir 4.5 Identifiers in the same name space with overlapping visibility should be typographically unambiguous

## Category
Advisory

## Applies to
C90, C99

## Amplification
The definition of the term “unambiguous” should be determined for a project taking into account the alphabet and language in which the source code is being written.

For the Latin alphabet as used in English words, it is advised as a minimum that identifiers should not differ by any combination of:
* The interchange of a lowercase character with its uppercase equivalent;
* The presence or absence of the underscore character;
* The interchange of the letter “O”, and the digit “0”;
* The interchange of the letter “I”, and the digit “1”;
* The interchange of the letter “I”, and the letter “l” (el);
* The interchange of the letter “l” (el), and the digit “1”;
* The interchange of the letter “S”, and the digit “5”;
* The interchange of the letter “Z”, and the digit “2”;
* The interchange of the letter “n”, and the letter “h”;
* The interchange of the letter “B”, and the digit “8”;
* The interchange of the letter sequence “rn” (“r” followed by “n”), and the letter “m”;

## Rationale
Depending upon the font used to display the character set, it is possible for certain glyphs to appear the same, even though the characters are different. This may lead to the developer confusing an identifier with another one.

## Example
The following examples assume the interpretation suggested in the Amplification for the Latin alphabet and English language.

```c
int32_t id1_a_b_c;
int32_t id1_abc;    /* Non-compliant */

int32_t id2_abc;
int32_t id2_ABC;    /* Non-compliant */

int32_t id3_a_bc;
int32_t id3_ab_c;   /* Non-compliant */

int32_t id4_I;
int32_t id4_1;      /* Non-compliant */

int32_t id5_Z;
int32_t id5_2;      /* Non-compliant */

int32_t id6_O;
int32_t id6_0;      /* Non-compliant */

int32_t id7_B;
int32_t id7_8;      /* Non-compliant */

int32_t id8_rn;
int32_t id8_m;      /* Non-compliant */

int32_t id9_rn;
struct
{
  int32_t id9_m;    /* Compliant */
};
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
