# Rule 16.4 Every switch statement shall have a default label
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
The *switch-clause* following the *default* label shall, prior to the terminating *break* statement, contain either:
- A statement, or
- A comment.
## Rationale
The requirement for a *default* label is defensive programming. Any statements following the *default* label are intended to take some appropriate action. If no statements follow the label then the comment can be used to explain why no specific action has been taken.
## Example
```c
int16_t x;

switch ( x )
{
 case 0:
 ++x;
 break;
 case 1:
 case 2:
 break;
 /* Non-compliant - default label is required */
}

int16_t x;

switch ( x )
{
 case 0:
 ++x;
 break;
 case 1:
 case 2:
 break;
 default: /* Compliant - default label is present */
 errorflag = 1; /* should be non-empty if possible */
 break;
}

enum Colours
{ RED, GREEN, BLUE } colour;

switch ( colour )
{
 case RED:
 next = GREEN;
 break;
 case GREEN:
 next = BLUE;
 break;
 case BLUE:
 next = RED;
 break;
 /* Non-compliant - no default label.
 * Even though all values of the enumeration are
 * handled there is no guarantee that colour takes
 * one of those values */
}
```
## See also
Rule 2.1, Rule 16.1

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
