# Rule 20.15 *#define* and *#undef* shall not be used on a reserved identifier or reserved macro name

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
See the Amplification for Rule 5.10 for a description of the relevant identifiers and macro names.

This rule also prohibits the use of *#define* or *#undef* on the identifier *defined* as this results in explicitly undefined behaviour.

The C Standard states that defining a macro with the same name as:
*   A macro defined in a standard header, or
*   An identifier with file scope declared in a standard header

is well-defined provided that the header is not included. This rule does not permit such definitions on the grounds that they are likely to cause confusion.

*Note:* the macro `NDEBUG` is not defined in a standard header and may therefore be *#define*‘d.

## Rationale
Reserved identifiers and reserved macro names are intended for use by the implementation. Removing or changing the meaning of a reserved macro may result in undefined behaviour.

## Example
```c
#undef __LINE__         /* Non-compliant - begins with _        */
#define _GUARD_H 1      /* Non-compliant - begins with _        */
#undef _BUILTIN_sqrt    /* Non-compliant - the implementation
                         * may use _BUILTIN_sqrt for other
                         * purposes, e.g. generating a sqrt
                         * instruction                          */

#define defined         /* Non-compliant - reserved identifier  */
#define errno my_errno  /* Non-compliant - library identifier   */
#define isneg( x ) ( ( x ) < 0 ) /* Compliant - rule doesn't include
                                  * future library
                                  * directions                  */
```

## See also
Rule 5.10, Rule 20.4, Rule 20.5

---

Copyright The MISRA Consortium Limited © [Date - March 2025].