# Rule 6.3 A bit-field shall not be declared as a member of a union

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
A member of a union shall not be declared as a bit-field.

This rule does not apply to sub-objects within union members that do not themselves have a union type.

## Rationale
The exact bitwise position of a bit-field within a storage unit is implementation-defined. Therefore, if two bit-fields are declared such that they fit within the same storage unit of a union, the compiler is not required to overlay them over one another beginning from the starting bit of the storage unit.

If the union is used for *type-punning*, it is therefore unclear which bits of the previously-stored value will be accessed by the bit-field.

If the union is not intended to be used for *type-punning*, there is no point in declaring the members as bit-fields, because no space will be saved (a complete storage unit will need to be allocated within the union anyway).

## Example
```c
/* Compliant - if the user wants to type-pun, the bits of 'big' which will
   ... be overlaid are clearly identified */
union U1 {
  uint8_t  small;
  uint32_t big;
};

/* Non-compliant - it is unclear which, if any, bits of 'big' are overlaid by
   ... 'small' in this type */
union U2 {
  uint32_t small:8;
  uint32_t big;
};

/* Non-compliant - it is unclear if any bits of 'big' are overlaid by
   ... 'small' in this type */
union U3 {
  uint32_t small: 8;
  uint32_t big  :24;
};

/* Compliant - a sub-object can be a bit-field */
union U4 {
  struct {
    uint8_t a:4;
    uint8_t b:4;
    uint8_t c:4;
    uint8_t d:4;
  } q;
  uint16_t r;
};
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].