# Rule 0–1–9 (Required) There shall be no dead code.

## Rationale
Any executed statement whose removal would not affect program output constitutes dead code (also know as redundant code). It is unclear to a reviewer if this is intentional or has occurred due to an error.

## Example
```c
int16_t has_dead_code ( int16_t para ) 
{ 
 int16_t local = 99;
 para = para + local; 
 local = para; // dead code – Non-compliant
 if ( 0 == local ) // dead code – Non-compliant 
 { // dead code – Non-compliant 
 local++; // dead code – Non-compliant 
 } // dead code – Non-compliant 
 return para; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
