# Rule 12–1–1 (Required) An object’s dynamic type shall not be used from the body of its constructor or destructor.

## Amplification
[Undefined 10.4(6)]

## Rationale
During construction and destruction of an object, its final type may be different to that of the completely constructed object. The result of using an object’s dynamic type in a constructor or destructor may not be consistent with developer expectations.
The dynamic type of an object is used in the following constructs:
* typeid on a class with a virtual function or a virtual function in a base class.
* dynamic_cast
* A virtual call to a virtual function.

This rule also prohibits a call being made to a pure virtual function from within a constructor or destructor. Such calls lead to undefined behaviour.

## Example
```c
class B1 
{ 
public: 
 B1 ( ) 
 { 
 typeid ( B1 ); // Compliant, B1 not polymorphic 
 } 
};
class B2 
{ 
public: 
 virtual ~B2 ( ); 
 virtual void foo ( ); 
 B2 ( ) 
 { 
 typeid ( B2 ); // Non-compliant 
 B2::foo ( ); // Compliant – not a virtual call 
 foo ( ); // Non-compliant 
 dynamic_cast< B2* > ( this ); // Non-compliant 
 } 
};
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
