# Rule 12–1–2 (Advisory) All constructors of a class should explicitly call a constructor for all of its immediate base classes and all virtual base classes.

## Rationale
This rule reduces confusion over which constructor will be used, and with what parameters.

## Example
```c
class A 
{ 
public: 
 A ( ) 
 { 
 } 
};
class B : public A 
{ 
public: 
 B ( ) // Non-compliant – benign, but should be B ( ) : A ( ) 
 { 
 } 
};
class V 
{ 
public: 
 V ( ) 
 { 
 } 
 V ( int32_t i ) 
 { 
 } 
};
class C1 : public virtual V 
{ 
public: 
 C1 ( ) : V ( 21 ) 
 { 
 } 
};
class C2 : public virtual V 
{ 
public: 
 C2 ( ) : V ( 42 ) 
 { 
 } 
};
class D: public C1, public C2 
{ 
public: 
 D ( ) // Non-compliant 
 { 
 } 
};
```
There would appear to be an ambiguity here, as D only includes one copy of V. Which version of V’s constructor is executed and with what parameter? In fact, V’s default constructor is always executed. This would be the case even if C1 and C2 constructed their bases with the same integer parameter.
This is clarified by making the initialization explicit, as in:
```c
D ( ) : C1 ( ), C2 ( ), V ( ) 
{ 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
