# Rule 2–7–1 (Required) The character sequence /* shall not be used within a C-style comment.

## Rationale
C++ does not support the nesting of C-style comments even though some compilers support this as a non-portable language extension. A comment beginning with /* continues until the first */ is encountered. Any /* occurring inside a comment is a violation of this rule.

## Example
Consider the following code fragment:
```c
/* some comment, end comment marker accidentally omitted
Perform_Critical_Safety_Function(X); 
/* this "comment" is Non-compliant */
```
In reviewing the code containing the call to the function, the assumption is that it is executed code.
Because of the accidental omission of the end comment marker, the call to Perform_Critical_Safety_Function will not be executed.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
