# Rule 3–2–1 (Required) All declarations of an object or function shall have compatible types.

## Amplification
[NDR 3.2(3), Undefined 3.2(5)]

## Rationale
It is undefined behaviour if the declarations of an object or function in two different translation units do not have compatible types.
The easiest way of ensuring object or function types are compatible is to make the declarations identical.

## Example
```c
// File a.cpp 
extern int32_t a; 
extern int32_t b []; 
extern char_t c;
int32_t f1 ( ); 
int32_t f2 ( int32_t );
// File b.cpp 
extern int64_t a; // Non-compliant – not compatible 
extern int32_t b [ 5 ]; // Compliant 
int16_t c; // Non-compliant
char_t f1 ( ); // Non-compliant 
char_t f2 ( char_t ); // Compliant – not the same function as 
 // int32_t f2 ( int32_t )
```

## See also
Rule 3–9–1

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
