# Rule 5–0–18 (Required) >, >=, <, <= shall not be applied to objects of pointer type, except where they point to the same array.

## Rationale
Attempting to make comparisons between pointers will produce undefined behaviour if the two pointers do not point to the same object.
Note: it is permissible to address the next element beyond the end of an array, but accessing this element is not allowed.

## Example
```c
void f1 ( ) 
{ 
 int32_t a1[ 10 ]; 
 int32_t a2[ 10 ];
 int32_t * p1 = a1;
 if ( p1 < a1 ) // Compliant 
 { 
 }
 if ( p1 < a2 ) // Non-compliant 
 { 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
