# Rule 5–2–1 (Required) Each operand of a logical && or || shall be a postfix‑expression.

## Rationale
The effect of this rule is to require that operands are appropriately parenthesized. Parentheses are important in this situation both for readability of code and for ensuring that the behaviour is as the developer intended.

## Exception
Where an expression consists of either a sequence of only logical && or a sequence of only logical ||, extra parentheses are not required.

## Example
```c
if ( x == 0 && ishigh ) // Non-compliant 
if ( ( x == 0 ) && ishigh ) // Compliant 
if ( x || y || z ) // Compliant by exception, 
 // if x, y and z bool 
if ( x || y && z ) // Non-compliant 
if ( x || ( y && z ) ) // Compliant 
if ( x && !y ) // Non-compliant 
if ( x && ( !y ) ) // Compliant 
if ( is_odd( y ) && x ) // Compliant
if ( ( x > c1 ) && ( y > c2 ) && ( z > c3 ) ) // Compliant - 
 // exception 
if ( ( x > c1 ) && ( y > c2 ) || ( z > c3 ) ) // Non-compliant 
if ( ( x > c1 ) && ( ( y > c2 ) || ( z > c3 ) ) ) // Compliant as 
 // extra() used
```
Note that this rule is a special case of Rule 5–0–2.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
