# Rule 7–5–3 (Required) A function shall not return a reference or a pointer to a parameter that is passed by reference or const reference.

## Rationale
It is implementation-defined behaviour whether the reference parameter is a temporary object or a reference to the parameter. If the implementation uses a local copy (temporary object), this will be destroyed when the function returns. Any attempt to use such an object after its destruction will lead to undefined behaviour.

## Example
```c
int32_t * fn1 ( int32_t & x ) 
{ 
 return ( &x ); // Non-compliant 
}
int32_t * fn2 ( ) 
{ 
 int32_t i = 0;
 return fn1 ( i ); 
}
const int32_t * fn3 ( const int32_t & x ) 
{ 
 return ( &x ); // Non-compliant 
}
int32_t & fn4 ( int32_t & x ) 
{ 
 return ( x ); // Non-compliant 
}
const int32_t & fn5 ( const int32_t & x ) 
{ 
 return ( x ); // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
