# Rule 28.3.1 Predicates shall not have persistent side effects

## Category
Required

## Analysis
Undecidable, System

## Amplification
When a template parameter is named `Compare`, `Predicate`, or `BinaryPredicate` in the C++
Standard Library, every callable passed as an argument of that type is a *predicate*.

In addition to not having *persistent side effects*, if the *predicate* is a *function object*, its `operator()`
shall be declared `const`.

*Note:* the `operator()` of a lambda closure is `const` unless the lambda is declared `mutable`.

## Rationale
It is *implementation defined* if the *predicate* used by an algorithm will be copied. The state of such a
*predicate* may therefore unexpectedly be different if a copy is made. Additionally, most algorithms do
not specify in which order the *predicates* will be invoked, or on which objects. This makes it very difficult
to implement a sensible *predicate* with mutable internal state.

Ideally, a tool will provide a mechanism that allows the identification of additional *predicates* in order
to include them in the analysis scope of this rule.

## Example
```cpp
bool bar( std::vector< int32_t > & v, int32_t & count )
{
 return std::any_of( v.begin(), v.end(),
 [&count]( int32_t i ) // Non-compliant
 {
 if ( i == 3 )
 {
 ++count; // Persistent side effect
 return true;
 }
 return false;
 } );
}

struct Comp
{
 bool operator()( int32_t a, int32_t b ) // Non-compliant - not const
 {
 return a > b;
 }
};

std::set< int32_t, Comp > mySet;
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
