# Rule 8.1.1 A non-*transient lambda* shall not implicitly capture `this`

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
If a lambda with implicit capture (having `=` or `&` in the capture list) attempts to capture a member
variable of a class, what is in fact captured is the `this` pointer. This behaviour can be surprising, and
may result in *undefined behaviour* if the lambda is called after the object’s lifetime has ended. This issue
cannot occur for a *transient lambda*.

Note: implicitly capturing `this` using `[=]` is deprecated from C++20.

## Example
```cpp
class A
{
  int16_t val;

  void f()
  {
    auto a1 = [=]() // Non-compliant - val is not captured, but
    { return val; }; // 'this' is implicitly captured

    auto a2 = [&]() // Non-compliant - val is not captured, but
    { return val; }; // 'this' is implicitly captured

    auto a3 = [this]() // Compliant - 'this' explicitly captured
    { return val; };

    auto a4 = [self = *this]() // Compliant - current object captured by copy
    { return self.val; };

    auto i = [&]() // Rule does not apply - transient lambda
    { return val; } ();
  }
};
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
