# Rule 8.19.1 The comma operator should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies to the use of the comma operator, but not when a comma is used as the fold operator
within a fold expression.

## Rationale
Use of the comma operator is generally detrimental to the readability of code, and the same effect
can usually be achieved by other means.

## Example
```cpp
f( ( 1, 2 ), 3 ); // Non-compliant - how many parameters?

template< typename ... Ts >
void print_all_of( const Ts &... ts )
{
  ( print( ts ), ... ); // Rule does not apply
}
```
The following example is non-compliant with other rules:
```cpp
for ( i = 0, p = &a[ 0 ]; i < N; ++i, ++p ) // Non-compliant
{
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
