# Rule 9.6.3 The goto statement shall jump to a label declared later in the function body

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
The unconstrained use of `goto` can lead to programs that are extremely difficult to comprehend and
analyse. However, flags may need to be introduced to give the required control flow when it is not
used, with the possibility that the flags may themselves make the code less transparent than if `goto`
were used. The restricted use of `goto` is therefore allowed where that use will not lead to semantics
contrary to developer expectations.

This rule prohibits the use of back jumps as they can be used to introduce iteration without using the
well-defined iteration statements supplied by the language.

*Note:* the C++ Standard places restrictions on the uses of forward jumps. For example, it is not
permitted to jump from a point where a local variable with initialization is not in scope to a point
where it is in scope.

## Example
```cpp
void f()
{
 int32_t x = 0;

L1:
 if ( x == 10 )
 {
 goto L2; // Compliant
 }
 else
 {
 ++x;
 goto L1; // Non-compliant
 }

L2:
 return;
}
```

## See also
Rule 9.6.1, Rule 9.6.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
