# Dir 4.12 Dynamic memory allocation shall not be used

## Category
Required

## Applies to
C90, C99

## Amplification
This rule applies to all dynamic memory allocation packages including:
* Those provided by The Standard Library;
* Third-party packages.

## Rationale
The Standard Library’s dynamic memory allocation and deallocation routines can lead to undefined behaviour as described in Rule 21.3. Any other dynamic memory allocation system is likely to exhibit undefined behaviours that are similar to those of The Standard Library.

The specification of third-party routines shall be checked to ensure that dynamic memory allocation is not being used inadvertently.

If a decision is made to use dynamic memory, care shall be taken to ensure that the software behaves in a predictable manner. For example, there is a risk that:
* Insufficient memory may be available to satisfy a request — care must be taken to ensure that there is a safe and appropriate response to an allocation failure;
* There is a high variance in the execution time required to perform allocation or deallocation depending on the pattern of usage and resulting degree of fragmentation.

## Example
For convenience, these examples are based around use of The Standard Library’s dynamic memory functions as their interfaces are well-known.

In this example, the behaviour is undefined following the first call to *free* because the value of the pointer `p` becomes indeterminate. Although the value stored in the pointer is unchanged following the call to *free*, it is possible, on some targets, that the memory to which it points no longer exists and the act of copying that pointer could cause a memory exception.

```c
#include <stdlib.h>

void f ( void )
{
  char *p = ( char * ) malloc ( 10 );
  char *q;

  free ( p );
  q = p;      /* Undefined behaviour - value of p is indeterminate */

  p = ( char * ) malloc ( 20 );
  free ( p );
  p = NULL;   /* Assigning NULL to freed pointer makes it determinate */
}
```

## See also
Dir 4.1, Rule 18.7, Rule 21.3, Rule 22.1, Rule 22.2

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
