# Rule 13.3 A full expression containing an increment (++) or decrement (--) operator should have no other potential side effects other than that caused by the increment or decrement operator
## Category
Advisory
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
A function call is considered to be a *side effect* for the purposes of this rule.
All sub-expressions of the *full expression* are treated as if they were evaluated for the purposes of this rule, even if specified as not being evaluated by the C Standard.
## Rationale
The use of increment and decrement operators in combination with other operators is not recommended because:
- It can significantly impair the readability of the code;
- It introduces additional *side effects* into a statement with the potential for undefined behaviour (covered by Rule 13.2).
It is clearer to use these operations in isolation from any other operators.
## Example
```c
/* The expression: */
u8a = u8b++
/* is non-compliant. The non-compliant expression statement: */
u8a = ++u8b + u8c--;
/* is clearer when written as the following sequence: */
++u8b;
u8a = u8b + u8c;
u8c--;

/* The following are all compliant because the only side effect in each expression is caused by the increment or decrement operator. */
x++;
a[ i ]++;
b.x++;
c->x++;
++( *p );
*p++;
( *p )++;

/* The following are all non-compliant because they contain a function call as well as an increment or decrement operator: */
if ( ( f ( ) + --u8a ) == 0u )
{
}
g ( u8b++ );

/* The following are all non-compliant even though the sub-expression containing the increment or decrement operator or some other side effect is not evaluated: */
u8a = ( 1u == 1u ) ? 0u : u8b++;

if ( u8a++ == ( ( 1u == 1u ) ? 0u : f ( ) ) )
{
}
```
## See also
Rule 13.2

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
