# Rule 15.5 A function should have a single point of exit at the end
## Category
Advisory
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
A function should have no more than one *return* statement.
When a *return* statement is used, it should be the final statement in the *compound statement* that forms the body of the function.
## Rationale
A single point of exit is required by IEC 61508 and ISO 26262 as part of the requirements for a modular approach.
Early returns may lead to the unintentional omission of function termination code.
If a function has exit points interspersed with statements that produce *persistent side effects*, it is not easy to determine which *side effects* will occur when the function is executed.
## Example
```c
/* In the following non-compliant code example, early returns are used to validate the function parameters. */
bool_t f ( uint16_t n, char *p )
{
 if ( n > MAX )
 {
 return false;
 }
 if ( p == NULL )
 {
 return false;
 }
 return true;
}
```
## See also
Rule 17.4

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
