# Rule 16.3 An unconditional break statement shall terminate every switch-clause
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
If a developer fails to end a *switch-clause* with a *break* statement, then control flow “falls” into the following *switch-clause* or, if there is no such clause, off the end and into the statement following the *switch* statement. Whilst falling into a following *switch-clause* is sometimes intentional, it is often an error. An unterminated *switch-clause* occurring at the end of a *switch* statement may fall into any *switch-clauses* which are added later.
To ensure that such errors can be detected, the last statement in every *switch-clause* shall be a *break* statement, or if the *switch-clause* is a *compound statement*, the last statement in the *compound statement* shall be a *break* statement.
Note: a *switch-clause* is defined as containing at least one statement. Two consecutive labels, *case* or *default*, do not have any intervening statement and are therefore permitted by this rule.
## Example
```c
switch ( x )
{
 case 0:
 break; /* Compliant - unconditional break */
 case 1: /* Compliant - empty fall through allows a group */
 case 2:
 break; /* Compliant */
 case 4:
 a = b; /* Non-compliant - break omitted */
 case 5:
 if ( a == b )
 {
 ++a;
 break; /* Non-compliant - conditional break */
 }
 default:
 ; /* Non-compliant - default must also have a break */
}
```
## See also
Rule 16.1

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
