# Rule 16.7 A switch-expression shall not have essentially Boolean type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
The C Standard requires the controlling expression of a *switch* statement to have an integer type. Since the type that is used to implement Boolean values is an integer, it is possible to have a *switch* statement controlled by a Boolean expression. In this instance an *if-else* construct would be more appropriate.
## Example
```c
switch ( x == 0 ) /* Non-compliant - essentially Boolean */
{ /* In this case an "if-else" would be more logical */
 case false:
 y = x;
 break;
 default:
 y = z;
 break;
}
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
