# Rule 17.11 A function that never returns should be declared with a _Noreturn function specifier
## Category
Advisory
## Analysis
Undecidable, System
## Applies to
C11
## Rationale
Declaring a function that cannot return as *_Noreturn* highlights that this is “by design”.
## Exception
This rule does not apply to *main()*, as the C Standard states that it is a constraint violation for *main()* to be declared with the *_Noreturn* function specifier.
## Example
```c
void f ( void ) /* Non-compliant - exit() call means there is no return */
{
 exit ( 0 );
}
```
## See also
Rule 17.9

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
