# Rule 18.2 Subtraction between pointers shall only be applied to pointers that address elements of the same array
## Category
Required
## Analysis
Undecidable, System
## Applies to
C90, C99, C11
## Rationale
This rule applies to expressions of the form
`pointer_expression_1 - pointer_expression_2`
It is undefined behaviour if `pointer_expression_1` and `pointer_expression_2` do not point to elements of the same array or the element one beyond the end of that array.
## Example
```c
#include <stddef.h>

void f1 ( int32_t *ptr )
{
 int32_t a1[ 10 ];
 int32_t a2[ 10 ];
 int32_t *p1 = &a1[ 1 ];
 int32_t *p2 = &a2[ 10 ];
 ptrdiff_t diff;

 diff = p1 - a1; /* Compliant */
 diff = p2 - a2; /* Compliant */
 diff = p1 - p2; /* Non-compliant */
 diff = ptr - p1; /* Non-compliant */
}
```
## See also
Dir 4.1, Rule 18.4

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
