# Rule 17.12 A function identifier should only be used with either a preceding &, or with a parenthesized parameter list

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
A function identifier not preceded by `&` and not followed by a parenthesized parameter list (which may be empty) can be confusing: it may not be clear whether the intent is to call the function (but the parenthesized parameter list has accidentally been omitted) or the intent is to obtain the function address.

## Example
```c
typedef int32_t (*pfn_i)(void);

extern int32_t    func1 ( void ); /* Note: A function         */
extern int32_t (*func2)( void ); /* Note: A function pointer */

void func ( void )
{
  pfn_i pfn1 = &func1;            /* Compliant     */
  pfn_i pfn2 = func1;             /* Non-compliant */

  int32_t i32a = (*pfn1)();       /* Compliant - explicit call via a fn-pointer */
  pfn1();                         /* Compliant - implicit call via a fn-pointer */

  if ( func1 == func2 )           /* Non-compliant */
  {
    /* ... */
  }

  if ( func1 ( ) == func2 ( ) )   /* Compliant - comparing return values */
  {
    /* ... */
  }

  if ( &func1 == func2 )          /* Compliant - comparing a function's address */
  {
    /* ... */
  }
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].