# Rule 18.10 Pointers to variably-modified array types shall not be used

## Category
Mandatory

## Analysis
Decidable, Single Translation Unit

## Applies to
C99, C11

## Amplification
A pointer to a variably-modified array type shall not be used in the declaration of any object or parameter.

A parameter declared to have an array type is not a pointer-to-array type (unless it is an array of arrays), because it is rewritten to a pointer to the element type.

## Rationale
Compatibility between array types requires the size specifiers for the pointed-to arrays to have equal values. However, for variably-modified array types this cannot be determined at compile-time.

If two pointers to array types are used in any way that requires them to be compatible (such as assignment), and the size specifiers for the pointed-to array are not the same, the behaviour is undefined. This is undecidable in general, effectively leaving all such operations untyped.

## Example
```c
/* Non-compliant */
void f1 (uint16_t n, uint16_t (* a) [n])
{
  uint16_t ( *p )[ 20 ];
  p = a; /* undefined unless n == 20, but types always assumed compatible */
}

/* Compliant */
void f2 (uint16_t n, uint16_t a[n])
{
  uint16_t * p;
  p = a; /* pointed-to type is not variably-modified, always well-defined */
}
```

## See also
Rule 18.8

---

Copyright The MISRA Consortium Limited © [Date - March 2025].