# Rule 8.18 There shall be no tentative definitions in a header file

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
A tentative definition in a *header file* results in multiple instances of the object being created, in each source file that *#includes* that *header file*.

## Example
```c
/* module.h */
int32_t i;          /* Non-compliant - tentative definition */
extern int32_t j;   /* Compliant     - external declaration */

/* module.c */
#include "module.h"
int32_t i;          /* Compliant     - tentative definition - assume used later */ 
int32_t j = 0;      /* Compliant     - defining declaration */
```

## See also
Rule 8.4, Rule 8.5, Rule 8.6, Rule 8.8

---

Copyright The MISRA Consortium Limited © [Date - March 2025].