# Rule 0–1–1 (Required) A project shall not contain unreachable code.

## Rationale
Code is unreachable if there is no syntactic (control flow) path to it. If such code exists, it is unclear if this is intentional or simply that an appropriate path has been accidentally omitted.
Compilers may choose not to generate code for these constructs, meaning that, even if the unreachable code is intentional, it may not be present in the final executable code.
Missing statements, often caused by editing activities, are a common source of unreachable code.

## Example
```c
int16_t with_unreach ( int16_t para ) 
{ 
 int16_t local;
 local = 0;
 switch ( para ) 
 {
 local = para; // unreachable – Non-compliant
 case 1: 
 { 
 break; 
 }
 default: 
 { 
 break; 
 }
 } 
 return para; 
 para++; // unreachable – Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
