# Rule 0–1–8 (Required) All functions with void return type shall have external side effect(s).

## Rationale
A function which does not return a value and which does not have external side effects will only consume time and will not contribute to the generation of any outputs, which may not meet developer expectations.
The following are examples of external side effects:
* Reading or writing to a file, stream, etc.;
* Changing the value of a non local variable;
* Changing the value of an argument having reference type;
* Using a volatile object;
* Raising an exception.

## Example
```c
void pointless ( void ) // Non-compliant – no external side effects 
{ 
 int16_t local;
 local = 0; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
