# Rule 3–4–1 (Required) An identifier declared to be an object or type shall be defined in a block that minimizes its visibility.

## Rationale
Defining variables in the minimum block scope possible reduces the visibility of those variables and therefore reduces the possibility that these identifiers will be used accidentally. A corollary of this is that global objects (including singleton function objects) shall be used in more than one function.

## Example
```c
void f ( int32_t k ) 
{ 
 int32_t j = k * k; // Non-compliant
 { 
 int32_t i = j; // Compliant
 std::cout << i << j << std::endl; 
 } 
}
```
In the above example, the definition of j could be moved into the same block as i, reducing the possibility that j will be incorrectly used later in f.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
