# Rule 3–9–3 (Required) The underlying bit representations of floating-point values shall not be used.

## Amplification
[Implementation 3.9.1(8)]

## Rationale
The storage layout used for floating-point values may vary from one compiler to another, and therefore no floating-point manipulations shall be made which rely directly on the way the values are stored. The in-built operators and functions, which hide the storage details from the developer, should be used.

## Example
```c
float32_t My_fabs ( float32_t f ) 
{ 
 uint8_t * pB = reinterpret_cast< uint8_t * >( &f );
 *( pB + 3 ) &= 0x7f; // Non-compliant – generate the absolute value 
 // of an IEEE-754 float value. 
 return ( f ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
