# Rule 6–4–6 (Required) The final clause of a switch statement shall be the default-clause.

## Rationale
The requirement for a final default-clause is defensive programming. This clause shall either take appropriate action, or else contain a suitable comment as to why no action is taken.

## Exception
If the condition of a switch statement is of type enum, and all the enumerators are listed in case labels, then the default-clause is not required as the rules associated with enums are intended to ensure that the enum cannot be assigned values outside of its set of enumerators. Note that it may still be appropriate to include a default-clause for the purpose of defensive programming.

## Example
```c
switch ( int16 ) 
{ 
case 0: 
 break; 
case 1: 
case 2: 
 break; 
 // Non-compliant – default clause is required. 
 }
enum Colours { RED, BLUE, GREEN } colour;
switch ( colour ) 
{ 
 case RED: 
 break; 
 case GREEN: 
 break; 
 // Non-compliant – default clause is required. 
}
switch ( colour ) 
{ 
 case RED: 
 break; 
 case BLUE: 
 break; 
 case GREEN: 
 break; 
 // Compliant – exception allows no default in this case 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
