# Rule 7–3–3 (Required) There shall be no unnamed namespaces in header files.

## Rationale
An unnamed namespace will be unique within each translation unit. Any declarations appearing in an unnamed namespace in a header will refer to different entities in each translation unit, which may not be consistent with developer expectations.

## Example
```c
// Header.hpp 
namespace // Non-compliant 
{ 
 extern int32_t x; 
}
// File1.cpp 
#include "Header.hpp"
namespace 
{ 
 int32_t x; 
}
void fn_a ( void ) 
{ 
 x = 24; 
}
// File2.cpp 
#include "Header.hpp"
namespace 
{ 
 int32_t x; 
}
void fn_b ( void ) 
{ 
 fn_a ( ); 
 if ( x == 24 ) // This x will not have been initialized. 
 { 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
