
From [Effective Dart](https://dart.dev/effective-dart/usage#dont-use-true-or-false-in-equality-operations):

**DON'T** use `true` or `false` in equality operations.

This lint applies only if the expression is of a non-nullable `bool` type.

**BAD:**
```dart
if (someBool == true) {
}
while (someBool == false) {
}
```

**GOOD:**
```dart
if (someBool) {
}
while (!someBool) {
}
```