
If you meant to test if the object has type `Foo`, instead write `Foo _`.

**BAD:**
```dart
void f(Object? x) {
  if (x case num) {
    print('int or double');
  }
}
```

**GOOD:**
```dart
void f(Object? x) {
  if (x case num _) {
    print('int or double');
  }
}
```

If you do mean to test that the matched value (which you expect to have the
type `Type`) is equal to the type literal `Foo`, then this lint can be
silenced using `const (Foo)`.

**BAD:**
```dart
void f(Object? x) {
  if (x case int) {
    print('int');
  }
}
```

**GOOD:**
```dart
void f(Object? x) {
  if (x case const (int)) {
    print('int');
  }
}
```