Ensures that property-binding is used instead of interpolation in attributes.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<input type="text" name="{{ foo }}">
                         ~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input type="text" name="{{ foo }}bar">
                         ~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<input type="text" [name]="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="text" name="foo" [(ngModel)]="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="text" [name]="foo + 'bar'">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="text" [name]="foo | bar">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div>{{ content }}</div>
```

</details>
