Ensures ngSrc is used instead of src for img elements

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<ng-template>
  <img src="http://localhost">
       ~~~~~~~~~~~~~~~~~~~~~~
  <img [src]="'http://localhost'">
       ~~~~~~~~~~~~~~~~~~~~~~~~~~
  <img [src]="value">
       ~~~~~~~~~~~~~
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template>
  <img ngSrc="http://localhost" src="http://localhost">
                                ~~~~~~~~~~~~~~~~~~~~~~
  <img ngSrc="http://localhost" [src]="'http://localhost'">
                                ~~~~~~~~~~~~~~~~~~~~~~~~~~
  <img ngSrc="http://localhost" [src]="value">
                                ~~~~~~~~~~~~~
  <img [ngSrc]="otherValue" src="http://localhost">
                            ~~~~~~~~~~~~~~~~~~~~~~
  <img [ngSrc]="otherValue" [src]="'http://localhost'">
                            ~~~~~~~~~~~~~~~~~~~~~~~~~~
  <img [ngSrc]="otherValue" [src]="value">
                            ~~~~~~~~~~~~~
  <img [src]="otherValue" [ngSrc]="value">
       ~~~~~~~~~~~~~~~~~~
  <img src="data:image/png;base64" [ngSrc]="otherValue">
       ~~~~~~~~~~~~~~~~~~~~~~~~~~~
</ng-template>
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<img ngSrc="http://localhost">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img [ngSrc]="'http://localhost'>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img [ngSrc]="value">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img src="data:image/jpeg;base64">
```

</details>
