Disallows using `ViewEncapsulation.None`

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  encapsulation: ViewEncapsulation.None,
                                   ~~~~
  selector: 'app-foo-bar',
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import type { ViewEncapsulation } from '@angular/core';
import { HttpClient } from '@angular/common/http';

@Component({
  selector: 'app-foo-bar',
  'encapsulation': ViewEncapsulation.None
                                     ~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import { ViewEncapsulation } from '@angular/core';
import { HttpClient } from '@angular/common/http';

@Component({
  selector: 'app-foo-bar',
  ['encapsulation']: ViewEncapsulation.None
                                       ~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import { ViewEncapsulation } from '@angular/core';
import { HttpClient } from '@angular/common/http';

@Component({
  selector: 'app-foo-bar',
  [`encapsulation`]: ViewEncapsulation.None
                                       ~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  encapsulation: ViewEncapsulation.Emulated,
  selector: 'app-foo-bar'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  'encapsulation': ViewEncapsulation.Native,
  selector: 'app-foo-bar',
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  ['encapsulation']: ViewEncapsulation.ShadowDom,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
function encapsulation() {
  return ViewEncapsulation.None;
}

@Component({
  [`encapsulation`]: encapsulation()
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const encapsulation = 'templateUrl';
@Component({
  [encapsulation]: '../a.html'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const encapsulation = 'templateUrl';
@Component({
  encapsulation
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const test = 'test';
@Component({
  encapsulation: test,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  encapsulation: undefined,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const options = {};
@Component(options)
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  bootstrap: [Foo]
})
class Test {}
```

</details>
