Trailing newlines in non-empty files are a common UNIX idiom. Benefits of
trailing newlines include the ability to concatenate or append to files as well
as output files to the terminal without interfering with shell prompts.

## Rule Details

This rule enforces at least one newline (or absence thereof) at the end
of non-empty files.

Prior to v0.16.0 this rule also enforced that there was only a single line at
the end of the file. If you still want this behavior, consider enabling
[no-multiple-empty-lines](https://eslint.org/docs/rules/no-multiple-empty-lines) with `maxEOF` and/or
[no-trailing-spaces](https://eslint.org/docs/rules/no-trailing-spaces).

Examples of **incorrect** code for this rule:

```js
/*eslint eol-last: ["error", "always"]*/

function doSomething() {
  var foo = 2;
}
```

Examples of **correct** code for this rule:

```js
/*eslint eol-last: ["error", "always"]*/

function doSomething() {
  var foo = 2;
}\n
```
