### SCS0003 - XPath Injection 

The dynamic value passed to the XPath query should be validated.

#### Risk

If the user input is not properly filtered, a malicious user could extend the XPath query.

#### Vulnerable Code

```cs
var doc = new XmlDocument {XmlResolver = null};
doc.Load("/config.xml");
var results = doc.SelectNodes("/Config/Devices/Device[id='" + input + "']");

```

#### Solution

```cs
Regex rgx = new Regex(@"^[a-zA-Z0-9]+$");
if(rgx.IsMatch(input)) //Additional validation
{
    XmlDocument doc = new XmlDocument {XmlResolver = null};
    doc.Load("/config.xml");
    var results = doc.SelectNodes("/Config/Devices/Device[id='" + input + "']");
}

```

#### References

[CWE-643: Improper Neutralization of Data within XPath Expressions (‘XPath Injection’)](https://cwe.mitre.org/data/definitions/643.html)  
[WASC-39: XPath Injection](http://projects.webappsec.org/w/page/13247005/XPath%20Injection)  
[OWASP: XPATH Injection](https://www.owasp.org/index.php/XPATH%5FInjection)  
[Black Hat Europe 2012: Hacking XPath 2.0](http://media.blackhat.com/bh-eu-12/Siddharth/bh-eu-12-Siddharth-Xpath-WP.pdf)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)