<h2>Why is this an issue?</h2>
<p>Using the same value on both sides of certain operators is a code defect. In the case of logical operators, it is either a copy/paste error and,
therefore, a bug, or it is simply duplicated code and should be simplified. For bitwise operators and most binary mathematical operators, having the
same value on both sides of an operator yields predictable results and should be simplified as well to avoid further code defects.</p>
<p>This rule raises for the following operators.</p>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators">Equality operators</a>
  (<code>==</code> and <code>!=</code>) </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators">Comparison operators</a>
  (<code>&lt; =</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&gt;=</code>) </li>
  <li> The following <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/boolean-logical-operators">Logical
  Operators</a>:
    <ul>
      <li> Logical OR (<code>|</code> ) </li>
      <li> Conditional logical OR (<code>||</code>) </li>
      <li> Logical AND (<code>&amp;</code>) </li>
      <li> Conditional logical AND (<code>&amp;&amp;</code>) </li>
      <li> Logical exclusive OR (<code>^</code>) </li>
    </ul>  </li>
  <li> The following <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/arithmetic-operators">arithmetic
  operators</a>:
    <ul>
      <li> Subtraction (<code>-</code>) </li>
      <li> Division (<code>\</code>) </li>
      <li> Remainder operator (<code>%</code>) </li>
      <li> Subtraction assignment operator (<code>-=</code>) </li>
      <li> Divide assignment operator (<code>\=</code>) </li>
    </ul>  </li>
</ul>
<h3>Exceptions</h3>
<p>This rule ignores the following operators:</p>
<ul>
  <li> Multiplication (*) </li>
  <li> Addition (+) </li>
  <li> Assignment (=) </li>
  <li> <a
  href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators#left-shift-operator-">Left-shift
  (&lt;&lt;)</a> </li>
  <li> <a
  href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators#right-shift-operator-">Right-shift
  (&gt;&gt;)</a> </li>
</ul>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre>
if ( a == a ) // always true
{
  doZ();
}
if ( a != a ) // always false
{
  doY();
}
if ( a == b &amp;&amp; a == b ) // if the first one is true, the second one is too
{
  doX();
}
if ( a == b || a == b ) // if the first one is true, the second one is too
{
  doW();
}

int j = 5 / 5; // always 1
int k = 5 - 5; // always 0

c.Equals(c);    // always true
Object.Equals(c, c); // always true
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/arithmetic-operators">Arithmetic Operators</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/boolean-logical-operators">Boolean logical operators</a>
  </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators">Bitwise and shift
  operators</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators">Equality operators - test if two
  objects are equal or not</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators">Comparison operators</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/assignment-operator">Assignment operators</a> </li>
</ul>

