<h2>Why is this an issue?</h2>
<p>Because parameter names could be changed during refactoring, they should not be spelled out literally in strings. Instead, use
<code>nameof()</code>, and the string that’s output will always be correct.</p>
<p>This rule raises an issue when a string in the <code>throw</code> statement contains the name of one of the method parameters.</p>
<h3>Noncompliant code example</h3>
<pre>
void DoSomething(int someParameter, string anotherParam)
{
    if (someParameter &lt; 0)
    {
        throw new ArgumentException("Bad argument", "someParameter");  // Noncompliant
    }
    if (anotherParam == null)
    {
        throw new Exception("anotherParam should not be null"); // Noncompliant
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
void DoSomething(int someParameter)
{
    if (someParameter &lt; 0)
    {
        throw new ArgumentException("Bad argument", nameof(someParameter));
    }
    if (anotherParam == null)
    {
        throw new Exception($"{nameof(anotherParam)} should not be null");
    }
}
</pre>
<h3>Exceptions</h3>
<ul>
  <li> The rule doesn’t raise any issue when using C# &lt; 6.0. </li>
  <li> When the parameter name is contained in a sentence inside the <code>throw</code> statement string, the rule will raise an issue only if the
  parameter name is at least 5 characters long. This is to avoid false positives. </li>
</ul>

