<p>Lightweight Directory Access Protocol (LDAP) servers provide two main authentication methods: the <em>SASL</em> and <em>Simple</em> ones. The
<em>Simple Authentication</em> method also breaks down into three different mechanisms:</p>
<ul>
  <li> <em>Anonymous</em> Authentication </li>
  <li> <em>Unauthenticated</em> Authentication </li>
  <li> <em>Name/Password</em> Authentication </li>
</ul>
<p>A server that accepts either the <em>Anonymous</em> or <em>Unauthenticated</em> mechanisms will accept connections from clients not providing
credentials.</p>
<h2>Why is this an issue?</h2>
<p>When configured to accept the Anonymous or Unauthenticated authentication mechanism, an LDAP server will accept connections from clients that do
not provide a password or other authentication credentials. Such users will be able to read or modify part or all of the data contained in the hosted
directory.</p>
<h3>What is the potential impact?</h3>
<p>An attacker exploiting unauthenticated access to an LDAP server can access the data that is stored in the corresponding directory. The impact
varies depending on the permission obtained on the directory and the type of data it stores.</p>
<h4>Authentication bypass</h4>
<p>If attackers get write access to the directory, they will be able to alter most of the data it stores. This might include sensitive technical data
such as user passwords or asset configurations. Such an attack can typically lead to an authentication bypass on applications and systems that use the
affected directory as an identity provider.</p>
<p>In such a case, all users configured in the directory might see their identity and privileges taken over.</p>
<h4>Sensitive information leak</h4>
<p>If attackers get read-only access to the directory, they will be able to read the data it stores. That data might include security-sensitive pieces
of information.</p>
<p>Typically, attackers might get access to user account lists that they can use in further intrusion steps. For example, they could use such lists to
perform password spraying, or related attacks, on all systems that rely on the affected directory as an identity provider.</p>
<p>If the directory contains some Personally Identifiable Information, an attacker accessing it might represent a violation of regulatory requirements
in some countries. For example, this kind of security event would go against the European GDPR law.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<p>The following code indicates an anonymous LDAP authentication vulnerability because it binds to a remote server using an Anonymous Simple
authentication mechanism.</p>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath);
myDirectoryEntry.AuthenticationType = AuthenticationTypes.None; // Noncompliant

DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath, "u", "p", AuthenticationTypes.None); // Noncompliant
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath); // Compliant; default DirectoryEntry.AuthenticationType property value is "Secure" since .NET Framework 2.0

DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath, "u", "p", AuthenticationTypes.Secure);
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://datatracker.ietf.org/doc/html/rfc4513#section-5">RFC 4513 - Lightweight Directory Access Protocol (LDAP): Authentication
  Methods and Security Mechanisms</a> - Bind operations </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A07_2021-Identification_and_Authentication_Failures/">Top 10 2021 Category A7 - Identification and
  Authentication Failures</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A2_2017-Broken_Authentication">Top 10 2017 Category A2 - Broken Authentication</a>
  </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/521">CWE-521 - Weak Password Requirements</a> </li>
</ul>

