﻿# SA0001

<table>
<tr>
  <td>TypeName</td>
  <td>SA0001XmlCommentAnalysisDisabled</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA0001</td>
</tr>
<tr>
  <td>Category</td>
  <td>Special Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

All diagnostics of XML documentation comments has been disabled due to the current project configuration.

## Rule description

A violation of this rule occurs when a compilation (project) contains one or more files which are parsed with the
`DocumentationMode` set to `None`. This most frequently occurs when the project is configured to not produce an
XML documentation file during the build.

Each project should be configured to include an XML documentation file with the compiled output. Otherwise, the
semantics of all documentation comments are not checked and comments are likely to contain an increasing number of
errors over time.

## How to fix violations

To fix a violation of this rule, enable the XML documentation file as part of the project output by adding `<GenerateDocumentationFile>true</GenerateDocumentationFile>` to your project file.

**Note:** In some cases, enabling XML documentation output will produce a large number of warnings CS1573, CS1591,
and/or CS1712 to be reported. To improve the ability of teams to resolve SA0001 before CS1573, CS1591, and CS1712,
consider disabling these warnings by one of the following methods.

### Suppression via rule set files

CS1573, CS1591, and CS1712 are most easily suppressed by editing the rule set file. The severity of these rules may be
set to **Hidden** or **None** to hide them from the build output. When set to **Hidden**, code fixes for these
diagnostics as a documentation aid will function normally, but the warnings themselves will be hidden from view.

### Suppression via the project file

For users who sometimes build their project with older versions of C# (which do not support rule set files), these
warnings may be suppressed by configuring the `<NoWarn>` element in the project file. One easy way to configure both
the documentation output (which corrects SA0001) and the suppressions for CS1573, CS1591, and CS1712 is to add the
following property group to the project file.

```xml
<PropertyGroup>
  <!--
    Make sure any documentation comments which are included in code get checked for syntax during the build, but do
    not report warnings for missing comments.

    CS1573: Parameter 'parameter' has no matching param tag in the XML comment for 'parameter' (but other parameters do)
    CS1591: Missing XML comment for publicly visible type or member 'Type_or_Member'
  -->
  <DocumentationFile>$(OutputPath)$(AssemblyName).xml</DocumentationFile>
  <NoWarn>$(NoWarn),1573,1591,1712</NoWarn>
</PropertyGroup>
```

## How to suppress violations

This warning can only be suppressed by disabling the warning in the **ruleset** file for the project.
