﻿## SA1007

<table>
<tr>
  <td>TypeName</td>
  <td>SA1007OperatorKeywordMustBeFollowedBySpace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1007</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The operator keyword within a C# operator overload method is not followed by any whitespace.

## Rule description

A violation of this rule occurs when the operator keyword within an operator overload method is not followed by any whitespace. The operator keyword should always be followed by a single space. For example:

```csharp
public MyClass operator +(MyClass a, MyClass b)
{
}
```

## How to fix violations

To fix a violation of this rule, add a single space after the operator keyword.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1007:OperatorKeywordMustBeFollowedBySpace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1007 // OperatorKeywordMustBeFollowedBySpace
#pragma warning restore SA1007 // OperatorKeywordMustBeFollowedBySpace
```
