﻿## SA1027

<table>
<tr>
  <td>TypeName</td>
  <td>SA1027UseTabsCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1027</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The code contains a tab or space character which is not consistent with the current project settings.

## Rule description

A violation of this rule occurs whenever the code contains a tab or space character which is not consistent with the
current project settings. By default, StyleCop Analyzers does not expect code to contain any tab characters. See
[Configuration.md](Configuration.md) for information about changing this behavior via **stylecop.json**.

In all configurations, this violation is always reported for tab characters that appear after the first non-whitespace
character on a line. When tab characters are used in these positions, it is not possible to ensure that varying tab
widths do not change the layout of code. See [Issue #2035](https://github.com/DotNetAnalyzers/StyleCopAnalyzers/issues/2035)
for more information.

### Default behavior

The default behavior matches the behavior of StyleCop Classic, which was based on the following rationale.

> Tabs should not be used within C# code, because the length of the tab character can vary depending upon the editor being
> used to view the code. This can cause the spacing and indexing of the code to vary from the developer's original
> intention, and can in some cases make the code difficult to read.
> 
> For these reasons, tabs should not be used, and each level of indentation should consist of four spaces. This will
> ensure that the code looks the same no matter which editor is being used to view the code.

### Exclusions

To avoid unintentionally changing the behavior of code, this violation is never reported in the following scenarios.

* String literals, including interpolated string literals in C# 6

* Character literals

* Commented code (line comments starting with `////`). This ensures that literals within commented code are not changed.

* Disabled text

    ```csharp
    #if DEBUG
    This is ignored in release configurations
    #else
    This is ignored in debug configurations
    #endif
    ```

## How to fix violations

To fix a violation of this rule, use spaces or tabs to indent lines according to the project settings, and avoid the use
of tabs aside from indentation.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1027:TabsMustNotBeUsed", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1027 // TabsMustNotBeUsed
#pragma warning restore SA1027 // TabsMustNotBeUsed
```
