﻿## SA1101

<table>
<tr>
  <td>TypeName</td>
  <td>SA1101PrefixLocalCallsWithThis</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1101</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A call to an instance member of the local class or a base class is not prefixed with 'this.', within a C# code file.

## Rule description

A violation of this rule occurs whenever the code contains a call to an instance member of the local class or a base class which is not prefixed with 'this.'. An exception to this rule occurs when there is a local override of a base class member, and the code intends to call the base class member directly, bypassing the local override. In this case the call can be prefixed with 'base.' rather than 'this.'.

By default, StyleCop disallows the use of underscores or *m_* to mark local class fields, in favor of the 'this.' prefix. The advantage of using 'this.' is that it applies equally to all element types including methods, properties, etc., and not just fields, making all calls to class members instantly recognizable, regardless of which editor is being used to view the code. Another advantage is that it creates a quick, recognizable differentiation between instance members and static members, which are not prefixed.

A final advantage of using the 'this.' prefix is that typing *this.* will cause Visual Studio to show the IntelliSense popup, making it quick and easy for the developer to choose the class member to call.

## How to fix violations

To fix a violation of this rule, insert the 'this.' prefix before the call to the class member.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1101:PrefixLocalCallsWithThis", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1101 // PrefixLocalCallsWithThis
#pragma warning restore SA1101 // PrefixLocalCallsWithThis
```
