﻿## SA1204

<table>
<tr>
  <td>TypeName</td>
  <td>SA1204StaticElementsMustAppearBeforeInstanceElements</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1204</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

A static element is positioned beneath an instance element of the same type.

## Rule description

A violation of this rule occurs when a static element is positioned beneath an instance element of the same type. All static elements should be placed above all instance elements of the same type to make it easier to see the interface exposed from the instance and static version of the class.

## How to fix violations

To fix an instance of this violation, place all static elements above all instance elements of the same type.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1204:StaticElementsMustAppearBeforeInstanceElements", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1204 // StaticElementsMustAppearBeforeInstanceElements
#pragma warning restore SA1204 // StaticElementsMustAppearBeforeInstanceElements
```
