﻿## SA1635

<table>
<tr>
  <td>TypeName</td>
  <td>SA1635FileHeaderMustHaveCopyrightText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1635</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file header at the top of a C# code file is missing copyright text.

## Rule description

A violation of this rule occurs when the file header at the top of a C# file does not contain text within its copyright tag. For example:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="Sprocket Enterprises">
// </copyright>
//-----------------------------------------------------------------------
```

A file header should include copyright text, as follows:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="Sprocket Enterprises">
//     Copyright (c) Sprocket Enterprises. All rights reserved.
// </copyright>
//-----------------------------------------------------------------------
```

## How to fix violations

To fix a violation of this rule, add your company's standard copyright text to the copyright tag.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1635:FileHeaderMustHaveCopyrightText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1635 // FileHeaderMustHaveCopyrightText
#pragma warning restore SA1635 // FileHeaderMustHaveCopyrightText
```
