<h2>Why is this an issue?</h2>
<p>Serializing a non-<code>static</code> inner class will result in an attempt at serializing the outer class as well. If the outer class is actually
serializable, then the serialization will succeed but possibly write out far more data than was intended.</p>
<p>Making the inner class <code>static</code> (i.e. "nested") avoids this problem, therefore inner classes should be <code>static</code> if possible.
However, you should be aware that there are semantic differences between an inner class and a nested one:</p>
<ul>
  <li> an inner class can only be instantiated within the context of an instance of the outer class. </li>
  <li> a nested (<code>static</code>) class can be instantiated independently of the outer class. </li>
</ul>
<h3>Noncompliant code example</h3>

```java
public class Raspberry implements Serializable {
  // ...

  public class Drupelet implements Serializable {  // Noncompliant; output may be too large
    // ...
  }
}
```
<h3>Compliant solution</h3>

```java
public class Raspberry implements Serializable {
  // ...

  public static class Drupelet implements Serializable {
    // ...
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/ZTdGBQ">CERT, SER05-J.</a> - Do not serialize instances of inner classes </li>
</ul>