<h2>Why is this an issue?</h2>
<p>The use of non-short-circuit logic in a boolean context is likely a mistake - one that could cause serious program errors as conditions are
evaluated under the wrong circumstances.</p>
<h3>Noncompliant code example</h3>

```java
if(getTrue() | getFalse()) { ... } // Noncompliant; both sides evaluated
```
<h3>Compliant solution</h3>

```java
if(getTrue() || getFalse()) { ... } // true short-circuit logic
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/WNYxBQ">CERT, EXP46-C.</a> - Do not use a bitwise operator with a Boolean-like operand </li>
</ul>